# The .astc File Format

The default file format for compressed textures generated by `astcenc`, as well
as from many other ASTC compressors, is the `.astc` format. This is a very
simple format consisting of a small header followed immediately by the binary
payload for a single image surface.

Header
======

The header is a fixed 16 byte structure, defined as storing only bytes to avoid
any endianness issues or incur any padding overhead.

```
struct astc_header
{
    uint8_t magic[4];
    uint8_t block_x;
    uint8_t block_y;
    uint8_t block_z;
    uint8_t dim_x[3];
    uint8_t dim_y[3];
    uint8_t dim_z[3];
};
```

Magic number
------------

The 4 byte magic number at the start of the file acts as a format identifier.

```
    magic[0] = 0x13;
    magic[1] = 0xAB;
    magic[2] = 0xA1;
    magic[3] = 0x5C;
```

Block size
----------

The `block_*` fields store the ASTC block dimensions in texels. For 2D images
the Z dimension must be set to 1.

Image dimensions
----------------

The `dim_*` fields store the image dimensions in texels.  For 2D images the
Z dimension must be set to 1.

Note that the image is not required to be an exact multiple of the compressed
block size; the compressed data may include padding that is discarded during
decompression.

Each dimension is a 24 bit unsigned value that is reconstructed from the stored
byte values as:

```
decoded_dim = dim[0] + (dim[1] << 8) + (dim[2] << 16);
```

Binary payload
==============

The binary payload is a byte stream that immediately follows the header. It
contains 16 bytes per compressed block. The number of compressed blocks is
determined from the header information.

- - -

_Copyright © 2020-2022, Arm Limited and contributors. All rights reserved._
