; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s

define arm_aapcs_vfpcc <4 x i32> @cmpeqz_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpeqz_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q2, q0, q1
; CHECK-NEXT:    vcmp.i32 eq, q2, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp eq <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpnez_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpnez_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ne <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsltz_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpsltz_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 lt, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp slt <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsgtz_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpsgtz_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 gt, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sgt <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpslez_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpslez_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 le, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sle <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsgez_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpsgez_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 ge, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sge <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpultz_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpultz_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ult <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpugtz_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpugtz_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 ne, q1, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ugt <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpulez_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpulez_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q2, #0x0
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 cs, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ule <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpugez_v4i1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: cmpugez_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcmp.i32 eq, q0, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp uge <4 x i32> %b, zeroinitializer
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}



define arm_aapcs_vfpcc <4 x i32> @cmpeq_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpeq_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 eq, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp eq <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpne_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpne_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 ne, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ne <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpslt_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpslt_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 gt, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp slt <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsgt_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpsgt_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 gt, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sgt <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsle_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpsle_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 ge, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sle <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsge_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpsge_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 ge, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp sge <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpult_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpult_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 hi, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ult <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpugt_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpugt_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 hi, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ugt <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpule_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpule_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 cs, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp ule <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpuge_v4i1(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: cmpuge_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 cs, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %c2 = icmp uge <4 x i32> %b, %c
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}


define arm_aapcs_vfpcc <4 x i32> @cmpeqr_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpeqr_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 eq, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp eq <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpner_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpner_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.i32 ne, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp ne <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsltr_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpsltr_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 lt, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp slt <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsgtr_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpsgtr_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 gt, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp sgt <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsler_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpsler_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 le, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp sle <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpsger_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpsger_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.s32 ge, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp sge <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpultr_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpultr_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdup.32 q2, r0
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 hi, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp ult <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpugtr_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpugtr_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 hi, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp ugt <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpuler_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpuler_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vdup.32 q2, r0
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 cs, q2, q1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp ule <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}

define arm_aapcs_vfpcc <4 x i32> @cmpuger_v4i1(<4 x i32> %a, <4 x i32> %b, i32 %c) {
; CHECK-LABEL: cmpuger_v4i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i32 eq, q0, zr
; CHECK-NEXT:    vcmpt.u32 cs, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <4 x i32> %a, zeroinitializer
  %i = insertelement <4 x i32> undef, i32 %c, i32 0
  %sp = shufflevector <4 x i32> %i, <4 x i32> undef, <4 x i32> zeroinitializer
  %c2 = icmp uge <4 x i32> %b, %sp
  %o = and <4 x i1> %c1, %c2
  %s = select <4 x i1> %o, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %s
}



define arm_aapcs_vfpcc <8 x i16> @cmpeqz_v8i1(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: cmpeqz_v8i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q2, q0, q1
; CHECK-NEXT:    vcmp.i16 eq, q2, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <8 x i16> %a, zeroinitializer
  %c2 = icmp eq <8 x i16> %b, zeroinitializer
  %o = and <8 x i1> %c1, %c2
  %s = select <8 x i1> %o, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %s
}

define arm_aapcs_vfpcc <8 x i16> @cmpeq_v8i1(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: cmpeq_v8i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vcmpt.i16 eq, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <8 x i16> %a, zeroinitializer
  %c2 = icmp eq <8 x i16> %b, %c
  %o = and <8 x i1> %c1, %c2
  %s = select <8 x i1> %o, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %s
}

define arm_aapcs_vfpcc <8 x i16> @cmpeqr_v8i1(<8 x i16> %a, <8 x i16> %b, i16 %c) {
; CHECK-LABEL: cmpeqr_v8i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i16 eq, q0, zr
; CHECK-NEXT:    vcmpt.i16 eq, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <8 x i16> %a, zeroinitializer
  %i = insertelement <8 x i16> undef, i16 %c, i32 0
  %sp = shufflevector <8 x i16> %i, <8 x i16> undef, <8 x i32> zeroinitializer
  %c2 = icmp eq <8 x i16> %b, %sp
  %o = and <8 x i1> %c1, %c2
  %s = select <8 x i1> %o, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %s
}


define arm_aapcs_vfpcc <16 x i8> @cmpeqz_v16i1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: cmpeqz_v16i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q2, q0, q1
; CHECK-NEXT:    vcmp.i8 eq, q2, zr
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <16 x i8> %a, zeroinitializer
  %c2 = icmp eq <16 x i8> %b, zeroinitializer
  %o = and <16 x i1> %c1, %c2
  %s = select <16 x i1> %o, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %s
}

define arm_aapcs_vfpcc <16 x i8> @cmpeq_v16i1(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: cmpeq_v16i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vcmpt.i8 eq, q1, q2
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <16 x i8> %a, zeroinitializer
  %c2 = icmp eq <16 x i8> %b, %c
  %o = and <16 x i1> %c1, %c2
  %s = select <16 x i1> %o, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %s
}

define arm_aapcs_vfpcc <16 x i8> @cmpeqr_v16i1(<16 x i8> %a, <16 x i8> %b, i8 %c) {
; CHECK-LABEL: cmpeqr_v16i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpt.i8 eq, q0, zr
; CHECK-NEXT:    vcmpt.i8 eq, q1, r0
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <16 x i8> %a, zeroinitializer
  %i = insertelement <16 x i8> undef, i8 %c, i32 0
  %sp = shufflevector <16 x i8> %i, <16 x i8> undef, <16 x i32> zeroinitializer
  %c2 = icmp eq <16 x i8> %b, %sp
  %o = and <16 x i1> %c1, %c2
  %s = select <16 x i1> %o, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %s
}


define arm_aapcs_vfpcc <2 x i64> @cmpeqz_v2i1(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: cmpeqz_v2i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q2, q0, q1
; CHECK-NEXT:    vmov r0, r1, d4
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r2, d5
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    csetm r0, eq
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <2 x i64> %a, zeroinitializer
  %c2 = icmp eq <2 x i64> %b, zeroinitializer
  %o = and <2 x i1> %c1, %c2
  %s = select <2 x i1> %o, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %s
}

define arm_aapcs_vfpcc <2 x i64> @cmpeq_v2i1(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c) {
; CHECK-LABEL: cmpeq_v2i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d4
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    eors r1, r3
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov r12, r2, d5
; CHECK-NEXT:    cset r1, eq
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csel r0, zr, r1, ne
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    rsbs r0, r0, #0
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r3, r0, d3
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eor.w r2, r3, r12
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    vmov r2, r3, d1
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    cset r2, eq
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csel r0, zr, r2, ne
; CHECK-NEXT:    rsbs r0, r0, #0
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <2 x i64> %a, zeroinitializer
  %c2 = icmp eq <2 x i64> %b, %c
  %o = and <2 x i1> %c1, %c2
  %s = select <2 x i1> %o, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %s
}

define arm_aapcs_vfpcc <2 x i64> @cmpeqr_v2i1(<2 x i64> %a, <2 x i64> %b, i64 %c) {
; CHECK-LABEL: cmpeqr_v2i1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    eors r3, r1
; CHECK-NEXT:    eors r2, r0
; CHECK-NEXT:    orr.w r12, r2, r3
; CHECK-NEXT:    vmov r3, r2, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    cset r2, eq
; CHECK-NEXT:    cmp.w r12, #0
; CHECK-NEXT:    csel r2, zr, r2, ne
; CHECK-NEXT:    rsbs r2, r2, #0
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r12, r2, d3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eor.w r0, r0, r12
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    cset r1, eq
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    csel r0, zr, r1, ne
; CHECK-NEXT:    rsbs r0, r0, #0
; CHECK-NEXT:    bfi r3, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %c1 = icmp eq <2 x i64> %a, zeroinitializer
  %i = insertelement <2 x i64> undef, i64 %c, i32 0
  %sp = shufflevector <2 x i64> %i, <2 x i64> undef, <2 x i32> zeroinitializer
  %c2 = icmp eq <2 x i64> %b, %sp
  %o = and <2 x i1> %c1, %c2
  %s = select <2 x i1> %o, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %s
}
