/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


/////////////////////// StdLib includes
#include <math.h>

/////////////////////// Qt includes
#include <QWidgetAction>
#include <QCheckBox>
#include <QLineEdit>
#include <QHBoxLayout>
#include <QLabel>

/////////////////////// pappsomspp includes


/////////////////////// Local includes
#include "MsXpS/libXpertMassGui/LabelledCheckBoxAction.hpp"

namespace MsXpS
{
  namespace libXpertMassGui
  {


LabelledCheckBoxAction::LabelledCheckBoxAction(const QString &check_box_text,
                                               Qt::CheckState check_state,
                                               const QString &action_text,
                                               QObject *parent)
  : QWidgetAction(parent)
{
  QWidget *composite_widget_p = new QWidget(static_cast<QWidget *>(parent));
  composite_widget_p->setAttribute(Qt::WA_Hover, true);

  composite_widget_p->setStyleSheet(R"(
QWidget:hover {
    background-color: palette(highlight);
}
  )");

  composite_widget_p->setSizePolicy(QSizePolicy::Expanding,
                                    QSizePolicy::Preferred);

  QHBoxLayout *layout_p = new QHBoxLayout(composite_widget_p);

  // The spin box where the user enter the value
  mpa_checkBox = new QCheckBox(check_box_text, composite_widget_p);
  mpa_checkBox->setCheckState(check_state);
  layout_p->addWidget(mpa_checkBox);

  mpa_actionTextLabel = new QLabel(action_text, composite_widget_p);
  mpa_actionTextLabel->setMinimumWidth(200);
  mpa_actionTextLabel->setAlignment(Qt::AlignLeft);
  mpa_actionTextLabel->setIndent(0);
  layout_p->addWidget(mpa_actionTextLabel);
  layout_p->setAlignment(mpa_actionTextLabel, Qt::AlignLeft);
  layout_p->addStretch(1);

  // Not needed we constructed the layout with the widget as argument.
  // composite_widget_p->setLayout(layout_p);

  setDefaultWidget(composite_widget_p);
}

LabelledCheckBoxAction::~LabelledCheckBoxAction()
{
}

QCheckBox *
LabelledCheckBoxAction::getWidget() const
{
  return mpa_checkBox;
}

QString
LabelledCheckBoxAction::getText() const
{
  return mpa_checkBox->text();
}

Qt::CheckState
LabelledCheckBoxAction::getCheckState() const
{
  return mpa_checkBox->checkState();
}

bool
LabelledCheckBoxAction::isChecked() const
{
  return mpa_checkBox->checkState() == Qt::CheckState::Checked;
}

  } // namespace libXpertMassGui
} // namespace MsXpS
