#!/usr/bin/env python3
"""
Simplified minimal reproducer for SOCKET_WRAPPER concurrency issue.
"""

import subprocess
import concurrent.futures


def run_subprocess():
    """Run a simple subprocess."""
    # Simple command that might trigger socket operations
    p = subprocess.Popen(['echo', 'test'],
                         stdout=subprocess.PIPE,
                         stderr=subprocess.PIPE)
    stdout, stderr = p.communicate()
    return stdout.decode().strip()


def main():
    # Run multiple subprocesses in parallel using ProcessPoolExecutor. The pool
    # executor processes do fd passing over unix socket.
    with concurrent.futures.ProcessPoolExecutor(max_workers=4) as executor:
        futures = [executor.submit(run_subprocess) for _ in range(10)]

        for i, future in enumerate(concurrent.futures.as_completed(futures)):
            result = future.result()
            print(f"Task {i}: {result}")


if __name__ == '__main__':
    main()
